package com.sowas.cuformsexample;

import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Spinner;

import com.sowas.cuforms.forms.CuFormPart;
import com.sowas.cuforms.forms.CuFormToolkit;
import com.sowas.cuforms.forms.CuLayouter;

public class View extends CuFormPart {
   public static final String ID = "CuFormsExample.view";

   @Override
   public Composite createHeadClient(Composite parent, CuFormToolkit tk) {
      return null;
   }
   
   @Override
   public void createBody(Composite body, CuFormToolkit tk) {      
      CuLayouter layouter = new CuLayouter(body, 4, false);
      setFormTitle("Titel");
      
      CLabel clabel = tk.createCLabel(body, "Label", SWT.NONE);
      layouter.applyLabelLayout(clabel);
      
      StyledText text = tk.createStyledText(body, SWT.BORDER);
      text.setText("Text");
      layouter.applyStyledTextLayout(text);
      
      CCombo ccombo = tk.createCCombo(body, SWT.BORDER);
      ccombo.setItems(new String[] {"Eins", "Zwei"});
      ccombo.select(0);
      layouter.applyCComboLayout(ccombo);
      
      Spinner spinner = tk.createSpinner(body, SWT.BORDER);
      layouter.applySpinnerLayout(spinner);
   }
   
   /**
    * Passing the focus request to the viewer's control.
    */
   @Override
   public void setFocus() {
   }
}