package com.sowas.cuforms.forms;

import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;

public class CuLayouter {

   public CuLayouter(Composite composite, int numColumns, boolean makeColumnsEqualWidth) {
      composite.setLayout(createLayout(numColumns, makeColumnsEqualWidth));
   }

   protected Layout createLayout(int numColumns, boolean makeColumnsEqualWidth) {
      GridLayout gl = new GridLayout(numColumns, makeColumnsEqualWidth);
      return gl;
   }
   
   public GridData applyLabelLayout(CLabel label) {
      GridData gd = createLayoutData();
      label.setLayoutData(gd);
      return gd;
   }

   public GridData applyTextLayout(Text text) {
      GridData gd = createLayoutData();
      text.setLayoutData(gd);
      return gd;
   }

   public GridData applyStyledTextLayout(StyledText text) {
      GridData gd = createLayoutData();
      text.setLayoutData(gd);
      return gd;
   }

   public GridData applyCComboLayout(CCombo ccombo) {
      GridData gd = createLayoutData();
      gd.heightHint = 15;
      ccombo.setLayoutData(gd);
      return gd;
   }

   public GridData applySpinnerLayout(Spinner spinner) {
      GridData gd = createLayoutData();
      gd.heightHint = 13;
      gd.verticalIndent = 1;
      spinner.setLayoutData(gd);
      return gd;
   }

   protected GridData createLayoutData() {
      return new GridData();
   }

}
