package com.sowas.cuforms.forms;
/*******************************************************************************
 * Copyright (c) 2009 Softwarebüro Schäfers.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser General 
 * Public License (LGPL) version 2.1
 *
 * The newest version can be found at:
 *     http:\\cuforms.sowas.com
 *******************************************************************************
 */

import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.part.ViewPart;

/**
 * 
 * @author Norbert Schäfers <n.schaefers@sowas.com>
 *
 */
public class CuFormPart extends ViewPart {
   Composite     parent;
   CuFormToolkit tk;
   Form          form;
   
   @Override
   public final void createPartControl(Composite parent) {
      this.parent = parent;
      tk = new CuFormToolkit(parent.getDisplay());
      form = tk.createForm(parent);
      createTitleHeading();
      createBody(form.getBody(), tk);
   }

   public void createBody(Composite parent, CuFormToolkit tk) {
   }

   protected void createTitleHeading() {
      tk.decorateFormHeading(form);
      Canvas canvas = new Canvas(form.getHead(), SWT.NONE);
      Composite headClient = createHeadClient(canvas, tk);
      if (headClient != null)
         form.setHeadClient(canvas);
   } 
   
   public Composite createHeadClient(Composite parent, CuFormToolkit tk) {
      return null;
   }

   public CuFormToolkit getFormToolkit() {
      return tk;
   }
   
   public void setFormTitle(String title) {
      form.setText(title);
   }
   
   @Override
   public void setFocus() {
   }

}
