package com.sowas.cuforms.forms;
/*******************************************************************************
 * Copyright (c) 2009 Softwarebüro Schäfers.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser General 
 * Public License (LGPL) version 2.1
 *
 * The newest version can be found at:
 *     http:\\cuforms.sowas.com
 *******************************************************************************
 */

import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.ui.forms.FormColors;
import org.eclipse.ui.forms.widgets.FormToolkit;

/**
 * 
 * @author Norbert Schäfers <n.schaefers@sowas.com>
 *
 */
public class CuFormToolkit extends FormToolkit {

   public CuFormToolkit(Display display) {
      super(new CuFormColors(display));
   }

   public CuFormToolkit(FormColors colors) {
      super(colors);
   }

   public Composite createComposite(Composite parent) {
      Composite comp = super.createComposite(parent);
      return comp;
   }
   
   public CLabel createCLabel(Composite parent, String text, int style) {
      CLabel clabel = new CLabel(parent, style);
      clabel.setText(text);
      clabel.setBackground(parent.getBackground());
      return clabel;
   }

   public CCombo createCCombo(Composite parent, int style) {
      CCombo ccombo = new CCombo(parent, style);
      return ccombo;
   }
   
   public StyledText createStyledText(Composite parent, int style){
      StyledText text = new StyledText(parent, style);
      return text;
   }
   
   public Spinner createSpinner(Composite parent, int style) {
      Spinner spinner = new Spinner(parent, style);
      return spinner;
   }
}
